<!-- tabpane.php -->
<div class="tab-pane-container">
    <div id="chat-tab-content">
        <div class="px-4 pt-4">
            <h4 class="mb-4">Chats</h4>
            <div class="search-box chat-search-box">
                <div class="input-group mb-3 bg-light input-group-lg rounded-lg">
                    <div class="input-group-prepend">
                        <button class="btn btn-link text-muted pr-1 text-decoration-none" type="button">
                            <i class="ri-search-line search-icon font-size-18"></i>
                        </button>
                    </div>
                    <input type="text" class="form-control bg-light" placeholder="Search messages or users" id="recentcontactsearch">
                </div>
            </div> <!-- Search Box-->
        </div> <!-- .p-4 -->
        
        <!-- Start user status -->
        <div class="px-4 pb-4" dir="ltr">
            <div class="owl-carousel owl-theme" id="user-status-carousel">
                <!-- Example static user -->
                <div class="item user chat-user-click" id="1" user-id="1">
                    <a href="#" class="user-status-box">
                        <div class="avatar-xs mx-auto d-block chat-user-img online">
                            <img src="assets/images/user-avatar.jpg" alt="user-img" class="img-fluid rounded-circle">
                            <span class="user-status"></span>
                        </div>
                        <h5 class="font-size-14 text-truncate mt-3 mb-1">User Name</h5>
                    </a>
                </div>
                <!-- Repeat for other users -->
            </div>
            <!-- end user status carousel -->
        </div>
        <!-- end user status -->

       <!-- Start chat-message-list -->
        <div class="px-2">
            <h5 class="mb-3 px-3 font-size-14">Recent</h5>
            <div class="chat-message-list" data-simplebar>
                <div class="chat-message-chatlist">
                    <!-- Example static recent contact -->
                    <a href="#" class="chat-message-item">
                        <div class="d-flex align-items-start">
                            <div class="chat-user-img align-self-center mr-3">
                                <img src="includes/avatar.png" class="rounded-circle" alt="user-avatar" style="height: 2.9rem; width: 2.9rem;">
                            </div>
                            <div class="overflow-hidden">
                                <h5 class="text-truncate font-size-14 mb-1">User Name</h5>
                                <p class="text-truncate mb-0">Recent message content</p>
                            </div>
                            <div class="font-size-12 ml-auto">
                                <p class="mb-0">2 min</p>
                            </div>
                        </div>
                    </a>
                    <!-- Repeat for other contacts -->
                </div>
            </div>
        </div>
        <!-- End chat-message-list -->
    </div>

    <div id="profile-tab-content" style="display: none;">
        <div class="user-profile-sidebar user">
            <div class="px-3 px-lg-4 pt-3 pt-lg-4">
                <div class="user-chat-nav text-right">
                    <button type="button" class="btn nav-btn" id="user-profile-hide">
                        <i class="ri-close-line"></i>
                    </button>
                </div>
            </div>

            <div class="text-center p-4 border-bottom">
                <div class="mb-4">
                    <img src="assets/images/user-avatar.jpg" class="rounded-circle avatar-lg img-thumbnail" alt="">
                </div>
                <h5 class="font-size-16 mb-1 text-truncate">User Name</h5>
                <p class="text-muted text-truncate mb-1"><i class="ri-record-circle-fill font-size-10 text-success mr-1"></i> Active</p>
            </div>
            <!-- End profile user -->

            <!-- Start user-profile-desc -->
            <div class="p-4 user-profile-desc" data-simplebar>
                <div class="text-muted">
                    <p class="mb-4">
                        If several languages coalesce, the grammar of the resulting language is more simple and regular than that of the individual.
                    </p>
                </div>

                <div id="profile-user-accordion" class="custom-accordion">
                    <div class="card shadow-none border mb-2">
                        <a href="#collapseOne" class="text-dark" data-toggle="collapse" aria-expanded="true" aria-controls="collapseOne">
                            <div class="card-header" id="headingOne">
                                <h5 class="font-size-14 m-0">
                                    <i class="ri-user-2-line mr-2 align-middle d-inline-block"></i> About
                                    <i class="mdi mdi-chevron-up float-right accor-plus-icon"></i>
                                </h5>
                            </div>
                        </a>

                        <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#profile-user-accordion">
                            <div class="card-body">
                                <div>
                                    <p class="text-muted mb-1">Name</p>
                                    <h5 class="font-size-14">User Name</h5>
                                </div>

                                <div class="mt-4">
                                    <p class="text-muted mb-1">Email</p>
                                    <h5 class="font-size-14">user@example.com</h5>
                                </div>

                                <div class="mt-4">
                                    <p class="text-muted mb-1">Time</p>
                                    <h5 class="font-size-14">2024-08-04</h5>
                                </div>

                                <div class="mt-4">
                                    <p class="text-muted mb-1">Location</p>
                                    <h5 class="font-size-14 mb-0">Location</h5>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End About card -->

                    <div class="card mb-1 shadow-none border">
                        <a href="#collapseTwo" class="text-dark collapsed" data-toggle="collapse" aria-expanded="false" aria-controls="collapseTwo">
                            <div class="card-header" id="headingTwo">
                                <h5 class="font-size-14 m-0">
                                    <i class="ri-attachment-line mr-2 align-middle d-inline-block"></i> Attached Files
                                    <i class="mdi mdi-chevron-up float-right accor-plus-icon"></i>
                                </h5>
                            </div>
                        </a>
                        <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#profile-user-accordion">
                            <div class="card-body">
                                <!-- Example static attached file -->
                                <div class="card p-2 border mb-2" id="msg-1">
                                    <div class="media align-items-center">
                                        <div class="avatar-sm mr-3">
                                            <div class="avatar-title bg-soft-primary text-primary rounded font-size-20">
                                                <i class="ri-file-text-fill"></i>
                                            </div>
                                        </div>
                                        <div class="media-body">
                                            <div class="text-left">
                                                <h5 class="font-size-14 mb-1">Filename</h5>
                                                <p class="text-muted font-size-13 mb-0">1.2 MB</p>
                                            </div>
                                        </div>
                                        <div class="ml-4">
                                            <ul class="list-inline mb-0 font-size-18">
                                                <li class="list-inline-item">
                                                    <a href="path/to/file" class="text-muted px-1" download>
                                                        <i class="ri-download-2-line"></i>
                                                    </a>
                                                </li>
                                                <li class="list-inline-item dropdown">
                                                    <a class="dropdown-toggle text-muted px-1" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        <i class="ri-more-fill"></i>
                                                    </a>
                                                    <div class="dropdown-menu dropdown-menu-right">
                                                        <a class="dropdown-item" href="#">Action</a>
                                                        <a class="dropdown-item" href="#">Another action</a>
                                                        <div class="dropdown-divider"></div>
                                                        <a class="dropdown-item deleteMessage" href="javascript:void(0)" msg-id="1">Delete</a>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <!-- Repeat for other files -->
                            </div>
                        </div>
                    </div>
                    <!-- End Attached Files card -->
                </div>
                <!-- end profile-user-accordion -->
            </div>
            <!-- end user-profile-desc -->
        </div>
    </div>

    <div id="groups-tab-content" style="display: none;">
    <div class="p-4">
        <div class="user-chat-nav float-right">
            <div data-toggle="tooltip" data-placement="bottom" title="Create group">
                <!-- Button trigger modal -->
                <button type="button" class="btn btn-link text-decoration-none text-muted font-size-18 py-0" data-toggle="modal" data-target="#addgroup-exampleModal">
                    <i class="ri-group-line mr-1"></i> Create Group
                </button>
            </div>
        </div>

        <h4 class="mb-4">Groups</h4>

        <!-- Start add group Modal -->
        <div class="modal fade" id="addgroup-exampleModal" tabindex="-1" role="dialog" aria-labelledby="addgroup-exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title font-size-14" id="addgroup-exampleModalLabel">Create a New Group.</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body p-4">
                        <form method="POST" action="" enctype="multipart/form-data">
                            <div class="form-group mb-4">
                                <label for="addgroup_name-input">Group Name</label>
                                <input type="text" class="form-control" placeholder="Enter Group Name" name="group_name" id="group_name">
                            </div>
                            <div class="form-group mb-4">
                                <label>Group Members</label>
                                <div class="mb-3">
                                    <button class="btn btn-light btn-sm" type="button" data-toggle="collapse" data-target="#groupmembercollapse" aria-expanded="false" aria-controls="groupmembercollapse">
                                        Select Members
                                    </button>
                                </div>

                                <div class="collapse" id="groupmembercollapse">
                                    <div class="card border">
                                        <div class="card-header">
                                            <h5 class="font-size-14 mb-0">Contacts</h5>
                                        </div>
                                        <div class="card-body p-2">
                                            <div data-simplebar style="max-height: 150px;">
                                                <div>
                                                    <!-- Example static contact list -->
                                                    <div class="p-3 font-weight-bold text-primary text-uppercase">A</div>
                                                    <ul class="list-unstyled contact-list">
                                                        <li id="1">
                                                            <div class="custom-control custom-checkbox">
                                                                <input type="checkbox" class="custom-control-input batchCheckbox" id="contact-1" name="checkboxusers[]" value="1">
                                                                <label class="custom-control-label" for="contact-1">User Name</label>
                                                            </div>
                                                        </li>
                                                        <!-- Repeat for other contacts -->
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="addgroupdescription-input">Description</label>
                                <textarea class="form-control" id="description" rows="3" placeholder="Enter Description" name="description"></textarea>
                            </div>
                        </form>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-link" data-dismiss="modal">Close</button>
                        <button type="button" class="btn btn-primary create-group" data-dismiss="modal">Create</button>
                    </div>
                </div>
            </div>
        </div>
        <!-- End add group Modal -->

        <div class="search-box chat-search-box">
            <div class="input-group bg-light input-group-lg rounded-lg">
                <div class="input-group-prepend">
                    <button class="btn btn-link text-decoration-none text-muted pr-1" type="button">
                        <i class="ri-search-line search-icon font-size-14"></i>
                    </button>
                </div>
                <input type="text" class="form-control bg-light" placeholder="Search groups..." id="groupsearch">
            </div>
        </div>
        <!-- end search-box -->
    </div>
    <div class="p-4 chat-message-list chat-group-list" data-simplebar>
        <div id="chat-group-list">
            <!-- Group list will be populated here -->
        </div>
    </div>
</div>

    <div id="contacts-tab-content" style="display: none;">
    <div class="p-4">
        <div class="user-chat-nav float-right">
            <div data-toggle="tooltip" data-placement="bottom" title="Add Contact">
                <!-- Button trigger modal -->
                <button type="button" class="btn btn-link text-decoration-none text-muted font-size-14 py-0" data-toggle="modal" data-target="#addContact-exampleModal">
                    <i class="ri-user-add-line"></i>
                </button>
            </div>
        </div>
        <h4 class="mb-4">Contacts</h4>

<!-- Start Add contact Modal -->
            <div class="modal fade" id="addContact-exampleModal" tabindex="-1" role="dialog" aria-labelledby="addContact-exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title font-size-14" id="addContact-exampleModalLabel">Add New Contact</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body p-4">
                            <form>
                                <div class="form-group mb-4">
                                    <label for="addcontactemail-input">Email</label>
                                    <input type="email" class="form-control" id="addcontactemail-input" placeholder="Enter Email">
                                </div>
                                <div class="form-group">
                                    <label for="addcontact-invitemessage-input">Invitation Message</label>
                                    <textarea class="form-control" id="addcontact-invitemessage-input" rows="3" placeholder="Enter Message"></textarea>
                                </div>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-link" data-dismiss="modal">Close</button>
                            <button type="button" class="btn btn-primary">Add</button>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Add contact Modal -->

            <div class="search-box chat-search-box">
                <div class="input-group bg-light input-group-lg rounded-lg">
                    <input type="text" class="form-control bg-light" placeholder="Search users.." id="search">
                    <div class="input-group-append">
                        <button id="search-button" class="btn btn-link text-decoration-none text-muted pr-1" type="button">
                            <i class="fas fa-search search-icon font-size-14"></i>
                        </button>
                    </div>
                </div>
            </div>
            <!-- End search-box -->

            <div class="p-4 chat-message-list chat-group-list" data-simplebar>
                <div class="search-contact-list">
                    <!-- Search results will be displayed here -->
                </div>
                <h5 class="chat-contactlist-title">Added Contacts</h5>
                <div class="chat-contactlist">
                    <!-- Existing contacts will be displayed here -->
                </div>
            </div>
            <!-- end contact lists -->
        </div>
        <!-- end p-4 -->
        
        </div>
 





    <div id="settings-tab-content" style="display: none;">
        <div class="px-4 pt-4">
            <h4 class="mb-0">Settings</h4>
        </div>

        <div class="text-center border-bottom p-4">
            <div class="mb-4 profile-user">
                <form name="avatar-form" id="avatar-form" method="post" accept-charset="utf-8" enctype="multipart/form-data" action="">
                    <input type="file" name="avatar" id="avatar" style="display:none;" />
                    <img id="imgAvatar" src="assets/images/user-avatar.jpg" class="rounded-circle avatar-lg img-thumbnail imgavatar" alt="">
                    <button type="button" id="btnAvatar" class="btn bg-light avatar-xs p-0 rounded-circle profile-photo-edit" onclick="document.getElementById('avatar').click();">
                        <i class="ri-pencil-fill"></i>
                    </button>
                </form>
            </div>

            <h5 id="user-profile-name" class="font-size-14 mb-1 text-truncate profile-newname">User Name</h5>
            <div class="dropdown d-inline-block mb-1">
                <a class="text-muted dropdown-toggle pb-1 d-block" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    Available <i class="mdi mdi-chevron-down"></i>
                </a>
                <div class="dropdown-menu">
                    <a class="dropdown-item" href="#">Available</a>
                    <a class="dropdown-item" href="#">Busy</a>
                </div>
            </div> 
        </div>
        <!-- End profile user -->

        <!-- Start User profile description -->
        <div class="p-4 user-profile-desc" data-simplebar>
            <div id="profile-setting-accordion" class="custom-accordion">
                <div class="card shadow-none border mb-2">
                    <a href="#profile-setting-personalinfocollapse" class="text-dark" data-toggle="collapse" aria-expanded="true" aria-controls="profile-setting-personalinfocollapse">
                        <div class="card-header" id="profile-setting-personalinfoheading">
                            <h5 class="font-size-14 m-0">Personal Info<i class="mdi mdi-chevron-up float-right accor-plus-icon"></i></h5>
                        </div>
                    </a>
                    <div id="profile-setting-personalinfocollapse" class="collapse show" aria-labelledby="profile-setting-personalinfoheading" data-parent="#profile-setting-accordion">
                        <div class="card-body">
                            <div class="float-right">
                                <button type="button" id="btnName" class="btn btn-light btn-sm"><i class="ri-edit-fill mr-1 align-middle"></i> Edit</button>
                            </div>
                            <div>
                                <p class="text-muted mb-1">Name</p>
                                <h5 id="profile-newname" class="font-size-14 profile-newname text-truncate">User Name</h5>
                                <div class="d-flex justify-content-between">
                                    <input type="text" class="form-control bg-soft-light border-light" name="profile-name" id="profile-name" style="display: none" />
                                    <div class="float-right">
                                        <button type="button" id="btnSave" class="btn btn-primary btn-block waves-effect waves-light" style="display: none"> Save</button>
                                    </div>
                                </div>
                            </div>

                            <div class="mt-4">
                                <p class="text-muted mb-1">Email</p>
                                <h5 class="font-size-14">user@example.com</h5>
                            </div>

                            <div class="mt-4">
                                <p class="text-muted mb-1">Time</p>
                                <h5 class="font-size-14">2024-08-04</h5>
                            </div>

                            <div class="mt-4">
                                <p class="text-muted mb-1">Location</p>
                                <h5 class="font-size-14 mb-0">Location</h5>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end profile card -->

                <div class="card shadow-none border mb-2">
                    <a href="#profile-setting-privacycollapse" class="text-dark collapsed" data-toggle="collapse" aria-expanded="false" aria-controls="profile-setting-privacycollapse">
                        <div class="card-header" id="profile-setting-privacyheading">
                            <h5 class="font-size-14 m-0">Privacy<i class="mdi mdi-chevron-up float-right accor-plus-icon"></i></h5>
                        </div>
                    </a>
                    <div id="profile-setting-privacycollapse" class="collapse" aria-labelledby="profile-setting-privacyheading" data-parent="#profile-setting-accordion">
                        <div class="card-body">
                            <div class="py-3">
                                <div class="media align-items-center">
                                    <div class="media-body overflow-hidden">
                                        <h5 class="font-size-14 mb-0 text-truncate">Profile photo</h5>
                                    </div>
                                    <div class="dropdown ml-2">
                                        <button class="btn btn-light btn-sm dropdown-toggle w-sm" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Everyone <i class="mdi mdi-chevron-down"></i></button>
                                        <div class="dropdown-menu dropdown-menu-right">
                                            <a class="dropdown-item" href="#">Everyone</a>
                                            <a class="dropdown-item" href="#">Selected</a>
                                            <a class="dropdown-item" href="#">Nobody</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="py-3 border-top">
                                <div class="media align-items-center">
                                    <div class="media-body overflow-hidden">
                                        <h5 class="font-size-14 mb-0 text-truncate">Last seen</h5>
                                    </div>
                                    <div class="ml-2">
                                        <div class="custom-control custom-switch">
                                            <input type="checkbox" class="custom-control-input" id="privacy-lastseenSwitch" checked>
                                            <label class="custom-control-label" for="privacy-lastseenSwitch"></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="py-3 border-top">
                                <div class="media align-items-center">
                                    <div class="media-body overflow-hidden">
                                        <h5 class="font-size-14 mb-0 text-truncate">Status</h5>
                                    </div>
                                    <div class="dropdown ml-2">
                                        <button class="btn btn-light btn-sm dropdown-toggle w-sm" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Everyone <i class="mdi mdi-chevron-down"></i></button>
                                        <div class="dropdown-menu dropdown-menu-right">
                                            <a class="dropdown-item" href="#">Everyone</a>
                                            <a class="dropdown-item" href="#">Selected</a>
                                            <a class="dropdown-item" href="#">Nobody</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="py-3 border-top">
                                <div class="media align-items-center">
                                    <div class="media-body overflow-hidden">
                                        <h5 class="font-size-14 mb-0 text-truncate">Read receipts</h5>
                                    </div>
                                    <div class="ml-2">
                                        <div class="custom-control custom-switch">
                                            <input type="checkbox" class="custom-control-input" id="privacy-readreceiptSwitch" checked>
                                            <label class="custom-control-label" for="privacy-readreceiptSwitch"></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="py-3 border-top">
                                <div class="media align-items-center">
                                    <div class="media-body overflow-hidden">
                                        <h5 class="font-size-14 mb-0 text-truncate">Groups</h5>
                                    </div>
                                    <div class="dropdown ml-2">
                                        <button class="btn btn-light btn-sm dropdown-toggle w-sm" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Everyone <i class="mdi mdi-chevron-down"></i></button>
                                        <div class="dropdown-menu dropdown-menu-right">
                                            <a class="dropdown-item" href="#">Everyone</a>
                                            <a class="dropdown-item" href="#">Selected</a>
                                            <a class="dropdown-item" href="#">Nobody</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end Privacy card -->

                <div class="card shadow-none border mb-2">
                    <a href="#profile-setting-securitynoticollapse" class="text-dark collapsed" data-toggle="collapse" aria-expanded="false" aria-controls="profile-setting-securitynoticollapse">
                        <div class="card-header" id="profile-setting-securitynotiheading">
                            <h5 class="font-size-14 m-0">Security<i class="mdi mdi-chevron-up float-right accor-plus-icon"></i></h5>
                        </div>
                    </a>
                    <div id="profile-setting-securitynoticollapse" class="collapse" aria-labelledby="profile-setting-securitynotiheading" data-parent="#profile-setting-accordion">
                        <div class="card-body">
                            <div>
                                <div class="media align-items-center">
                                    <div class="media-body overflow-hidden">
                                        <h5 class="font-size-14 mb-0 text-truncate">Show security notification</h5>
                                    </div>
                                    <div class="ml-2">
                                        <div class="custom-control custom-switch">
                                            <input type="checkbox" class="custom-control-input" id="security-notificationswitch">
                                            <label class="custom-control-label" for="security-notificationswitch"></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end Security card -->

                <div class="card shadow-none border mb-2">
                    <a href="#profile-setting-helpcollapse" class="text-dark collapsed" data-toggle="collapse" aria-expanded="false" aria-controls="profile-setting-helpcollapse">
                        <div class="card-header" id="profile-setting-helpheading">
                            <h5 class="font-size-14 m-0">Help<i class="mdi mdi-chevron-up float-right accor-plus-icon"></i></h5>
                        </div>
                    </a>
                    <div id="profile-setting-helpcollapse" class="collapse" aria-labelledby="profile-setting-helpheading" data-parent="#profile-setting-accordion">
                        <div class="card-body">
                            <div>
                                <div class="py-3">
                                    <h5 class="font-size-14 mb-0"><a href="#" class="text-body d-block">FAQs</a></h5>
                                </div>
                                <div class="py-3 border-top">
                                    <h5 class="font-size-14 mb-0"><a href="#" class="text-body d-block">Contact</a></h5>
                                </div>
                                <div class="py-3 border-top">
                                    <h5 class="font-size-14 mb-0"><a href="#" class="text-body d-block">Terms & Privacy policy</a></h5>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end Help card -->
            </div>
            <!-- end profile-setting-accordion -->
        </div>
        <!-- End User profile description -->
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    loadContacts(); // Load contacts by default when the page loads

    // Add event listener for search input
    document.getElementById('search').addEventListener('keyup', function(event) {
        if (event.key === 'Enter') {
            searchUser();
        }
    });

    // Add event listener for search button
    document.getElementById('search-button').addEventListener('click', function() {
        searchUser();
    });

    function searchUser() {
        const email = document.getElementById('search').value;

        // Validate email format
        const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (!emailPattern.test(email)) {
            displayErrorMessage('Please enter a valid email address.');
            return;
        }

        fetch('search_user.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: `email=${encodeURIComponent(email)}`
        })
        .then(response => response.json())
        .then(data => {
            const contactList = document.querySelector('.search-contact-list');
            contactList.innerHTML = ''; // Clear previous search results
            const errorMessage = document.querySelector('.search-error-message');
            if (data.status === 'success') {
                if (errorMessage) {
                    errorMessage.remove(); // Remove previous error message if any
                }
                const user = data.user;
                const contactItem = document.createElement('div');
                contactItem.className = 'search-result-item contact-item';
                contactItem.setAttribute('data-user-id', user.id);
                contactItem.innerHTML = `
                    <div class="d-flex align-items-start">
                        <div class="chat-user-img align-self-center mr-3">
                            <img src="${user.avatar}" class="rounded-circle avatar-xs" alt="">
                        </div>
                        <div class="overflow-hidden">
                            <h5 class="text-truncate font-size-14 mb-1">${user.name}</h5>
                            <p class="text-truncate mb-0">${data.is_contact ? 'Already In Contacts' : '<span class="add-contact text-primary" style="cursor: pointer; text-decoration: underline;" data-user-id="' + user.id + '">Add To Contacts</span>'}</p>
                        </div>
                    </div>
                `;
                contactList.appendChild(contactItem);

                if (!data.is_contact) {
                    // Add event listener to the add contact button
                    contactItem.querySelector('.add-contact').addEventListener('click', function() {
                        const userId = this.getAttribute('data-user-id');
                        fetch('add_contact.php', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/x-www-form-urlencoded'
                            },
                            body: `user_id=${encodeURIComponent(userId)}`
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.status === 'success') {
                                this.innerHTML = 'Already In Contacts';
                                this.style.textDecoration = 'none';
                                this.style.cursor = 'default';
                                this.classList.remove('text-primary');
                            } else {
                                displayErrorMessage(data.message);
                            }
                        })
                        .catch(error => displayErrorMessage('An error occurred while adding the contact.'));
                    });
                } else {
                    // Add event listener to open conversation on click
                    contactItem.addEventListener('click', function() {
                        openConversation(user.id, user.name, user.avatar);
                    });
                }
            } else {
                displayErrorMessage(data.message);
            }
        })
        .catch(error => displayErrorMessage('An error occurred while searching for the user.'));
    }

    function displayErrorMessage(message) {
        let errorMessage = document.querySelector('.search-error-message');
        if (errorMessage) {
            errorMessage.textContent = message;
        } else {
            errorMessage = document.createElement('p');
            errorMessage.className = 'search-error-message text-danger';
            errorMessage.textContent = message;
            document.querySelector('.search-box').appendChild(errorMessage);
        }
    }

    function loadContacts() {
        fetch('load_contacts.php')
        .then(response => response.json())
        .then(data => {
            const contactList = document.querySelector('.chat-contactlist');
            contactList.innerHTML = ''; // Clear existing contacts
            if (data.status === 'success') {
                data.contacts.forEach(contact => {
                    const contactItem = document.createElement('div');
                    contactItem.className = 'contact-item';
                    contactItem.setAttribute('data-user-id', contact.id);
                    contactItem.innerHTML = `
                        <div class="d-flex align-items-start">
                            <div class="chat-user-img align-self-center mr-3">
                                <img src="${contact.avatar}" class="rounded-circle avatar-xs" alt="">
                            </div>
                            <div class="overflow-hidden">
                                <h5 class="text-truncate font-size-14 mb-1">${contact.name}</h5>
                                <p class="text-truncate mb-0">${contact.email}</p>
                            </div>
                        </div>
                    `;
                    contactList.appendChild(contactItem);

                    // Add event listener to open conversation on click
                    contactItem.addEventListener('click', function() {
                        openConversation(contact.id, contact.name, contact.avatar);
                    });
                });
            } else {
                displayErrorMessage('Failed to load contacts.');
            }
        })
        .catch(error => displayErrorMessage('An error occurred while loading contacts.'));
    }

  function openConversation(userId, userName, userAvatar) {
    // Switch to chat tab
    document.getElementById('chat-tab').click();

    // Load conversation
    fetch(`load_conversation.php?user_id=${userId}`)
    .then(response => response.json())
    .then(data => {
        const conversationList = document.querySelector('.conversation-list');
        conversationList.innerHTML = ''; // Clear existing messages

        if (data.status === 'success' && data.messages.length > 0) {
            data.messages.forEach(message => {
                const messageItem = document.createElement('li');
                messageItem.className = message.from_user_id == <?php echo $_SESSION['user_id']; ?> ? 'right' : 'left';
                messageItem.innerHTML = `
                    <div class="conversation-list">
                        <div class="chat-avatar">
                            <img src="${message.avatar}" alt="" class="imgavatar">
                        </div>
                        <div class="user-chat-content">
                            <div class="ctext-wrap">
                                <div class="ctext-wrap-content">
                                    <p class="mb-0">${message.message}</p>
                                    <p class="chat-time mb-0">
                                        <i class="ri-time-line align-middle"></i> 
                                        <span class="align-middle">${message.created_at}</span>
                                    </p>
                                </div>
                            </div>
                            <div class="conversation-name">${message.name}</div>
                        </div>
                    </div>
                `;
                conversationList.appendChild(messageItem);
            });
        } else {
            const today = new Date();
            const date = today.toLocaleDateString();
            const time = today.toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'});
            const labelItem = document.createElement('li');
            labelItem.className = 'conversation-label';
            labelItem.innerHTML = `
                <div class="conversation-label-content">
                    <span>Start of conversation with ${userName}</span>
                    <span>${date}, ${time}</span>
                </div>
            `;
            conversationList.appendChild(labelItem);
        }

        // Move the contact to the top of the chat list
        const chatList = document.querySelector('.chat-message-chatlist');
        const chatItem = document.createElement('a');
        chatItem.className = 'chat-message-item';
        chatItem.setAttribute('href', '#');
        chatItem.innerHTML = `
            <div class="d-flex align-items-start">
                <div class="chat-user-img align-self-center mr-3">
                    <img src="${userAvatar}" class="rounded-circle" alt="user-avatar" style="height: 2.9rem; width: 2.9rem;">
                </div>
                <div class="overflow-hidden">
                    <h5 class="text-truncate font-size-14 mb-1">${userName}</h5>
                    <p class="text-truncate mb-0">Recent message content</p>
                </div>
                <div class="font-size-12 ml-auto">
                    <p class="mb-0">now</p>
                </div>
            </div>
        `;
        chatList.prepend(chatItem);
    })
    .catch(error => console.error('Error loading conversation:', error));
   }
});
</script>


<script>
document.addEventListener('DOMContentLoaded', function() {
    loadContacts(); // Load contacts by default when the page loads
    loadConversations(); // Load conversations by default when the page loads

    // Add event listener for search input
    document.getElementById('search').addEventListener('keyup', function(event) {
        if (event.key === 'Enter') {
            searchUser();
        }
    });

    // Add event listener for search button
    document.getElementById('search-button').addEventListener('click', function() {
        searchUser();
    });

    function searchUser() {
        const email = document.getElementById('search').value;

        // Validate email format
        const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (!emailPattern.test(email)) {
            displayErrorMessage('Please enter a valid email address.');
            return;
        }

        fetch('search_user.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: `email=${encodeURIComponent(email)}`
        })
        .then(response => response.json())
        .then(data => {
            const contactList = document.querySelector('.search-contact-list');
            contactList.innerHTML = ''; // Clear previous search results
            const errorMessage = document.querySelector('.search-error-message');
            if (data.status === 'success') {
                if (errorMessage) {
                    errorMessage.remove(); // Remove previous error message if any
                }
                const user = data.user;
                const contactItem = document.createElement('div');
                contactItem.className = 'search-result-item contact-item';
                contactItem.setAttribute('data-user-id', user.id);
                contactItem.innerHTML = `
                    <div class="d-flex align-items-start">
                        <div class="chat-user-img align-self-center mr-3">
                            <img src="${user.avatar}" class="rounded-circle avatar-xs" alt="">
                        </div>
                        <div class="overflow-hidden">
                            <h5 class="text-truncate font-size-14 mb-1">${user.name}</h5>
                            <p class="text-truncate mb-0">${data.is_contact ? 'Already In Contacts' : '<span class="add-contact text-primary" style="cursor: pointer; text-decoration: underline;" data-user-id="' + user.id + '">Add To Contacts</span>'}</p>
                        </div>
                    </div>
                `;
                contactList.appendChild(contactItem);

                if (!data.is_contact) {
                    // Add event listener to the add contact button
                    contactItem.querySelector('.add-contact').addEventListener('click', function() {
                        const userId = this.getAttribute('data-user-id');
                        fetch('add_contact.php', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/x-www-form-urlencoded'
                            },
                            body: `user_id=${encodeURIComponent(userId)}`
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.status === 'success') {
                                this.innerHTML = 'Already In Contacts';
                                this.style.textDecoration = 'none';
                                this.style.cursor = 'default';
                                this.classList.remove('text-primary');
                            } else {
                                displayErrorMessage(data.message);
                            }
                        })
                        .catch(error => displayErrorMessage('An error occurred while adding the contact.'));
                    });
                } else {
                    // Add event listener to open conversation on click
                    contactItem.addEventListener('click', function() {
                        openConversation(user.id, user.name, user.avatar);
                    });
                }
            } else {
                displayErrorMessage(data.message);
            }
        })
        .catch(error => displayErrorMessage('An error occurred while searching for the user.'));
    }

    function displayErrorMessage(message) {
        let errorMessage = document.querySelector('.search-error-message');
        if (errorMessage) {
            errorMessage.textContent = message;
        } else {
            errorMessage = document.createElement('p');
            errorMessage.className = 'search-error-message text-danger';
            errorMessage.textContent = message;
            document.querySelector('.search-box').appendChild(errorMessage);
        }
    }

    function loadContacts() {
        fetch('load_contacts.php')
        .then(response => response.json())
        .then(data => {
            const contactList = document.querySelector('.chat-contactlist');
            contactList.innerHTML = ''; // Clear existing contacts
            if (data.status === 'success') {
                data.contacts.forEach(contact => {
                    const contactItem = document.createElement('div');
                    contactItem.className = 'contact-item';
                    contactItem.setAttribute('data-user-id', contact.id);
                    contactItem.innerHTML = `
                        <div class="d-flex align-items-start">
                            <div class="chat-user-img align-self-center mr-3">
                                <img src="${contact.avatar}" class="rounded-circle avatar-xs" alt="">
                            </div>
                            <div class="overflow-hidden">
                                <h5 class="text-truncate font-size-14 mb-1">${contact.name}</h5>
                                <p class="text-truncate mb-0">${contact.email}</p>
                            </div>
                        </div>
                    `;
                    contactList.appendChild(contactItem);

                    // Add event listener to open conversation on click
                    contactItem.addEventListener('click', function() {
                        openConversation(contact.id, contact.name, contact.avatar);
                    });
                });
            } else {
                displayErrorMessage('Failed to load contacts.');
            }
        })
        .catch(error => displayErrorMessage('An error occurred while loading contacts.'));
    }

    function loadConversations() {
        fetch('load_conversations_list.php')
        .then(response => response.json())
        .then(data => {
            const chatList = document.querySelector('.chat-message-chatlist');
            chatList.innerHTML = ''; // Clear existing conversations
            if (data.status === 'success') {
                if (data.conversations.length > 0) {
                    const mostRecentConversation = data.conversations[0];
                    openConversation(mostRecentConversation.id, mostRecentConversation.name, mostRecentConversation.avatar);

                    data.conversations.forEach(conversation => {
                        const chatItem = document.createElement('a');
                        chatItem.className = 'chat-message-item';
                        chatItem.setAttribute('href', '#');
                        chatItem.setAttribute('data-user-id', conversation.id);
                        chatItem.innerHTML = `
                            <div class="d-flex align-items-start">
                                <div class="chat-user-img align-self-center mr-3">
                                    <img src="${conversation.avatar}" class="rounded-circle" alt="user-avatar" style="height: 2.9rem; width: 2.9rem;">
                                </div>
                                <div class="overflow-hidden">
                                    <h5 class="text-truncate font-size-14 mb-1">${conversation.name}</h5>
                                    <p class="text-truncate mb-0">${conversation.recent_message}</p>
                                </div>
                                <div class="font-size-12 ml-auto">
                                    <p class="mb-0">now</p>
                                </div>
                            </div>
                        `;
                        chatList.appendChild(chatItem);

                        // Add event listener to open conversation on click
                        chatItem.addEventListener('click', function(event) {
                            event.preventDefault();
                            openConversation(conversation.id, conversation.name, conversation.avatar);
                        });
                    });
                }
            } else {
                displayErrorMessage('Failed to load conversations.');
            }
        })
        .catch(error => displayErrorMessage('An error occurred while loading conversations.'));
    }

    function openConversation(userId, userName, userAvatar) {
        // Switch to chat tab
        document.getElementById('chat-tab').click();

        // Load conversation
        fetch(`load_conversation.php?user_id=${userId}`)
        .then(response => response.json())
        .then(data => {
            const conversationList = document.querySelector('.conversation-list');
            conversationList.innerHTML = ''; // Clear existing messages
            document.querySelector('.conversation-list').dataset.currentUserId = userId; // Set current user id

            if (data.status === 'success' && data.messages.length > 0) {
                data.messages.forEach(message => {
                    const messageItem = document.createElement('li');
                    messageItem.className = message.from_user_id == <?php echo $_SESSION['user_id']; ?> ? 'right' : 'left';
                    messageItem.innerHTML = `
                        <div class="conversation-list">
                            <div class="chat-avatar">
                                <img src="${message.avatar}" alt="" class="imgavatar">
                            </div>
                            <div class="user-chat-content">
                                <div class="ctext-wrap">
                                    <div class="ctext-wrap-content">
                                        <p class="mb-0">${message.message}</p>
                                        <p class="chat-time mb-0">
                                            <i class="ri-time-line align-middle"></i> 
                                            <span class="align-middle">${message.created_at}</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="conversation-name">${message.name}</div>
                            </div>
                        </div>
                    `;
                    conversationList.appendChild(messageItem);
                });
            } else {
                const today = new Date();
                const date = today.toLocaleDateString();
                const time = today.toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'});
                const labelItem = document.createElement('li');
                labelItem.className = 'conversation-label';
                labelItem.innerHTML = `
                    <div class="conversation-label-content">
                        <span>Start of conversation with ${userName}</span>
                        <span>${date}, ${time}</span>
                    </div>
                `;
                conversationList.appendChild(labelItem);
            }

            // Move the contact to the top of the chat list
            const chatList = document.querySelector('.chat-message-chatlist');
            if (!document.querySelector(`.chat-message-item[data-user-id="${userId}"]`)) {
                const chatItem = document.createElement('a');
                chatItem.className = 'chat-message-item';
                chatItem.setAttribute('href', '#');
                chatItem.setAttribute('data-user-id', userId);
                chatItem.innerHTML = `
                    <div class="d-flex align-items-start">
                        <div class="chat-user-img align-self-center mr-3">
                            <img src="${userAvatar}" class="rounded-circle" alt="user-avatar" style="height: 2.9rem; width: 2.9rem;">
                        </div>
                        <div class="overflow-hidden">
                            <h5 class="text-truncate font-size-14 mb-1">${userName}</h5>
                            <p class="text-truncate mb-0">Recent message content</p>
                        </div>
                        <div class="font-size-12 ml-auto">
                            <p class="mb-0">now</p>
                        </div>
                    </div>
                `;
                chatList.prepend(chatItem);

                // Add event listener to open conversation on click
                chatItem.addEventListener('click', function(event) {
                    event.preventDefault();
                    openConversation(userId, userName, userAvatar);
                });
            }
        })
        .catch(error => console.error('Error loading conversation:', error));
    }

    // File upload logic
    document.querySelector('.file-transfer-block form').addEventListener('submit', function(event) {
        event.preventDefault();

        const fileInput = document.querySelector('.file-transfer-block input[type="file"]');
        const descriptionInput = document.querySelector('.file-transfer-block input[type="text"]');
        const formData = new FormData();

        if (!fileInput.files[0] || !descriptionInput.value.trim()) {
            alert('Please attach a file and enter a description.');
            return;
        }

        formData.append('file', fileInput.files[0]);
        formData.append('description', descriptionInput.value.trim());
        formData.append('to_user_id', document.querySelector('.conversation-list').dataset.currentUserId);
        formData.append('session_token', '<?php echo $_SESSION["token"]; ?>');

        // Show progress indicator
        const sendButton = document.querySelector('.file-transfer-block button[type="submit"] i');
        sendButton.className = 'fas fa-spinner fa-spin';

        fetch('send_file.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                const messageItem = document.createElement('li');
                messageItem.className = 'right';
                messageItem.innerHTML = `
                    <div class="conversation-list">
                        <div class="chat-avatar">
                            <img src="<?php echo $_SESSION['user_avatar']; ?>" alt="" class="imgavatar">
                        </div>
                        <div class="user-chat-content">
                            <div class="ctext-wrap">
                                <div class="ctext-wrap-content">
                                    <p class="mb-0">${descriptionInput.value.trim()}</p>
                                    <p class="chat-time mb-0">
                                        <i class="ri-time-line align-middle"></i> 
                                        <span class="align-middle">${new Date().toLocaleString()}</span>
                                    </p>
                                </div>
                            </div>
                            <div class="conversation-name"><?php echo $_SESSION['user_name']; ?></div>
                        </div>
                    </div>
                `;
                document.querySelector('.conversation-list').appendChild(messageItem);

                // Reset form
                fileInput.value = '';
                descriptionInput.value = '';

                // Scroll to bottom
                document.querySelector('.conversation-list-container').scrollTop = document.querySelector('.conversation-list-container').scrollHeight;
            } else {
                alert(data.message);
            }

            // Restore send icon
            sendButton.className = 'fas fa-paper-plane fa-lg';
        })
        .catch(error => {
            console.error('Error uploading file:', error);
            alert('Error: Something went wrong.');

            // Restore send icon
            sendButton.className = 'fas fa-paper-plane fa-lg';
        });
    });
});
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    loadGroups(); // Load groups by default when the page loads

    // Add event listener for group creation
    document.querySelector('.create-group').addEventListener('click', function() {
        const groupName = document.getElementById('group_name').value.trim();
        const description = document.getElementById('description').value.trim();
        const selectedMembers = Array.from(document.querySelectorAll('.batchCheckbox:checked')).map(checkbox => checkbox.value);

        if (groupName && selectedMembers.length > 0) {
            const formData = new FormData();
            formData.append('group_name', groupName);
            formData.append('description', description);
            formData.append('members', JSON.stringify(selectedMembers));

            fetch('create_group.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 'success') {
                    alert('Group created successfully!');
                    loadGroups(); // Reload the group list
                } else {
                    alert('Error creating group: ' + data.message);
                }
            })
            .catch(error => console.error('Error:', error));
        } else {
            alert('Please enter a group name and select at least one member.');
        }
    });

    // Function to load groups
    function loadGroups() {
        fetch('load_groups.php')
        .then(response => response.json())
        .then(data => {
            const groupList = document.getElementById('chat-group-list');
            groupList.innerHTML = ''; // Clear existing groups

            if (data.status === 'success' && data.groups.length > 0) {
                data.groups.forEach(group => {
                    const groupItem = document.createElement('div');
                    groupItem.className = 'chat-message-item';
                    groupItem.setAttribute('data-group-id', group.id);
                    groupItem.innerHTML = `
                        <div class="d-flex align-items-start">
                            <div class="chat-user-img align-self-center mr-3">
                                <img src="assets/images/group-avatar.jpg" class="rounded-circle avatar-xs" alt="">
                            </div>
                            <div class="overflow-hidden">
                                <h5 class="text-truncate font-size-14 mb-1">${group.group_name}</h5>
                                <p class="text-truncate mb-0">${group.description}</p>
                            </div>
                            <div class="font-size-12 ml-auto">
                                <p class="mb-0">2 min</p>
                            </div>
                        </div>
                    `;
                    groupList.appendChild(groupItem);

                    // Add event listener to open group conversation on click
                    groupItem.addEventListener('click', function() {
                        openGroupConversation(group.id, group.group_name);
                    });
                });
            } else {
                const noGroupsItem = document.createElement('div');
                noGroupsItem.className = 'text-center';
                noGroupsItem.textContent = 'No groups available';
                groupList.appendChild(noGroupsItem);
            }
        })
        .catch(error => console.error('Error loading groups:', error));
    }

    // Function to open group conversation
    function openGroupConversation(groupId, groupName) {
        // Switch to chat tab
        document.getElementById('chat-tab').click();

        // Load group conversation
        fetch(`load_group_conversation.php?group_id=${groupId}`)
        .then(response => response.json())
        .then(data => {
            const conversationList = document.querySelector('.conversation-list');
            conversationList.innerHTML = ''; // Clear existing messages
            conversationList.dataset.currentGroupId = groupId; // Set current group id

            if (data.status === 'success' && data.messages.length > 0) {
                data.messages.forEach(message => {
                    const messageItem = document.createElement('li');
                    messageItem.className = message.from_user_id == <?php echo $_SESSION['user_id']; ?> ? 'right' : 'left';
                    messageItem.innerHTML = `
                        <div class="conversation-list">
                            <div class="chat-avatar">
                                <img src="${message.avatar}" alt="" class="imgavatar">
                            </div>
                            <div class="user-chat-content">
                                <div class="ctext-wrap">
                                    <div class="ctext-wrap-content">
                                        <p class="mb-0">${message.message}</p>
                                        <p class="chat-time mb-0">
                                            <i class="ri-time-line align-middle"></i> 
                                            <span class="align-middle">${message.created_at}</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="conversation-name">${message.name}</div>
                            </div>
                        </div>
                    `;
                    conversationList.appendChild(messageItem);
                });
            } else {
                const today = new Date();
                const date = today.toLocaleDateString();
                const time = today.toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'});
                const labelItem = document.createElement('li');
                labelItem.className = 'conversation-label';
                labelItem.innerHTML = `
                    <div class="conversation-label-content">
                        <span>Start of conversation in ${groupName}</span>
                        <span>${date}, ${time}</span>
                    </div>
                `;
                conversationList.appendChild(labelItem);
            }
        })
        .catch(error => console.error('Error loading group conversation:', error));
    }
});


document.addEventListener('DOMContentLoaded', function() {
    // Load contacts into the group member selection modal
    function loadGroupMembers() {
        fetch('load_contacts.php')
        .then(response => response.json())
        .then(data => {
            const groupMemberList = document.querySelector('#groupmembercollapse .contact-list');
            groupMemberList.innerHTML = ''; // Clear existing contacts

            if (data.status === 'success') {
                data.contacts.forEach(contact => {
                    const contactItem = document.createElement('li');
                    contactItem.setAttribute('id', contact.id);
                    contactItem.innerHTML = `
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input batchCheckbox" id="contact-${contact.id}" name="checkboxusers[]" value="${contact.id}">
                            <label class="custom-control-label" for="contact-${contact.id}">${contact.name}</label>
                        </div>
                    `;
                    groupMemberList.appendChild(contactItem);
                });
            } else {
                groupMemberList.innerHTML = '<li>No contacts available.</li>';
            }
        })
        .catch(error => console.error('Error loading group members:', error));
    }

    // Event listener to load group members when the modal is shown
    $('#addgroup-exampleModal').on('shown.bs.modal', function () {
        loadGroupMembers();
    });
});

</script>

    <script>
document.addEventListener('DOMContentLoaded', function() {
    // Load individual conversations in the chat tab
    function loadIndividualConversations() {
        fetch('load_conversations_list.php')
        .then(response => response.json())
        .then(data => {
            const chatList = document.querySelector('.chat-message-chatlist');
            chatList.innerHTML = ''; // Clear existing conversations
            if (data.status === 'success') {
                data.conversations.forEach(conversation => {
                    const chatItem = document.createElement('a');
                    chatItem.className = 'chat-message-item';
                    chatItem.setAttribute('href', '#');
                    chatItem.setAttribute('data-user-id', conversation.id);
                    chatItem.setAttribute('data-conversation-type', 'individual');
                    chatItem.innerHTML = `
                        <div class="d-flex align-items-start">
                            <div class="chat-user-img align-self-center mr-3">
                                <img src="${conversation.avatar}" class="rounded-circle" alt="user-avatar" style="height: 2.9rem; width: 2.9rem;">
                            </div>
                            <div class="overflow-hidden">
                                <h5 class="text-truncate font-size-14 mb-1">${conversation.name}</h5>
                                <p class="text-truncate mb-0">${conversation.recent_message}</p>
                            </div>
                            <div class="font-size-12 ml-auto">
                                <p class="mb-0">now</p>
                            </div>
                        </div>
                    `;
                    chatList.appendChild(chatItem);

                    // Event listener to open individual conversation
                    chatItem.addEventListener('click', function(event) {
                        event.preventDefault();
                        openConversation(conversation.id, conversation.name, conversation.avatar, 'individual');
                    });
                });
            }
        })
        .catch(error => console.error('Error loading conversations:', error));
    }

    // Load group conversations in the group tab
    function loadGroupConversations() {
        fetch('load_group_conversations_list.php')
        .then(response => response.json())
        .then(data => {
            const groupList = document.querySelector('#chat-group-list');
            groupList.innerHTML = ''; // Clear existing group conversations
            if (data.status === 'success') {
                data.groups.forEach(group => {
                    const groupItem = document.createElement('a');
                    groupItem.className = 'chat-message-item';
                    groupItem.setAttribute('href', '#');
                    groupItem.setAttribute('data-group-id', group.id);
                    groupItem.setAttribute('data-conversation-type', 'group');
                    groupItem.innerHTML = `
                        <div class="d-flex align-items-start">
                            <div class="chat-user-img align-self-center mr-3">
                                <img src="assets/images/group-avatar.jpg" class="rounded-circle avatar-xs" alt="group-avatar">
                            </div>
                            <div class="overflow-hidden">
                                <h5 class="text-truncate font-size-14 mb-1">${group.name}</h5>
                                <p class="text-truncate mb-0">${group.recent_message}</p>
                            </div>
                            <div class="font-size-12 ml-auto">
                                <p class="mb-0">now</p>
                            </div>
                        </div>
                    `;
                    groupList.appendChild(groupItem);

                    // Event listener to open group conversation
                    groupItem.addEventListener('click', function(event) {
                        event.preventDefault();
                        openConversation(group.id, group.name, 'assets/images/group-avatar.jpg', 'group');
                    });
                });
            }
        })
        .catch(error => console.error('Error loading group conversations:', error));
    }

    // Load both individual and group conversations when the page loads
    loadIndividualConversations();
    loadGroupConversations();

    // Open individual or group conversation based on the type
    function openConversation(id, name, avatar, type) {
        const conversationList = document.querySelector('.conversation-list');
        conversationList.innerHTML = ''; // Clear existing messages

        if (type === 'individual') {
            // Fetch and display individual conversation
            fetch(`load_conversation.php?user_id=${id}`)
            .then(response => response.json())
            .then(data => {
                if (data.status === 'success' && data.messages.length > 0) {
                    data.messages.forEach(message => {
                        const messageItem = document.createElement('li');
                        messageItem.className = message.from_user_id == '<?php echo $_SESSION['user_id']; ?>' ? 'right' : 'left';
                        messageItem.innerHTML = `
                            <div class="conversation-list">
                                <div class="chat-avatar">
                                    <img src="${message.avatar}" alt="" class="imgavatar">
                                </div>
                                <div class="user-chat-content">
                                    <div class="ctext-wrap">
                                        <div class="ctext-wrap-content">
                                            <p class="mb-0">${message.message}</p>
                                            <p class="chat-time mb-0">
                                                <i class="ri-time-line align-middle"></i> 
                                                <span class="align-middle">${message.created_at}</span>
                                            </p>
                                        </div>
                                    </div>
                                    <div class="conversation-name">${message.name}</div>
                                </div>
                            </div>
                        `;
                        conversationList.appendChild(messageItem);
                    });
                } else {
                    const labelItem = createConversationLabel(name);
                    conversationList.appendChild(labelItem);
                }
            })
            .catch(error => console.error('Error loading conversation:', error));
        } else if (type === 'group') {
            // Fetch and display group conversation
            fetch(`load_group_conversation.php?group_id=${id}`)
            .then(response => response.json())
            .then(data => {
                if (data.status === 'success' && data.messages.length > 0) {
                    data.messages.forEach(message => {
                        const messageItem = document.createElement('li');
                        messageItem.className = message.from_user_id == '<?php echo $_SESSION['user_id']; ?>' ? 'right' : 'left';
                        messageItem.innerHTML = `
                            <div class="conversation-list">
                                <div class="chat-avatar">
                                    <img src="${message.avatar}" alt="" class="imgavatar">
                                </div>
                                <div class="user-chat-content">
                                    <div class="ctext-wrap">
                                        <div class="ctext-wrap-content">
                                            <p class="mb-0">${message.message}</p>
                                            <p class="chat-time mb-0">
                                                <i class="ri-time-line align-middle"></i> 
                                                <span class="align-middle">${message.created_at}</span>
                                            </p>
                                        </div>
                                    </div>
                                    <div class="conversation-name">${message.name}</div>
                                </div>
                            </div>
                        `;
                        conversationList.appendChild(messageItem);
                    });
                } else {
                    const labelItem = createConversationLabel(name);
                    conversationList.appendChild(labelItem);
                }
            })
            .catch(error => console.error('Error loading group conversation:', error));
        }
    }

    // Helper function to create a conversation label
    function createConversationLabel(name) {
        const today = new Date();
        const date = today.toLocaleDateString();
        const time = today.toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'});
        const labelItem = document.createElement('li');
        labelItem.className = 'conversation-label';
        labelItem.innerHTML = `
            <div class="conversation-label-content">
                <span>Start of conversation with ${name}</span>
                <span>${date}, ${time}</span>
            </div>
        `;
        return labelItem;
    }
});
</script>

